/***********************\
|** GETABLE HEALTH AI **|
\***********************/
void getable_health_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.health_bars_left < 10 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 1, 2, 5, or 10 health
	if (sprites[sprite_number].frame == ITEM_HEALTH_1) hurt_player(1);
	else if (sprites[sprite_number].frame == ITEM_HEALTH_2) hurt_player(2);
	else if (sprites[sprite_number].frame == ITEM_HEALTH_5) hurt_player(5);
	else hurt_player(10);

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting a health pack
	player.score += 5;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_HEALTH_1) add_text_message("You got 1 health");
	else if (sprites[sprite_number].frame == ITEM_HEALTH_2) add_text_message("You got 2 health");
	else if (sprites[sprite_number].frame == ITEM_HEALTH_5) add_text_message("You got 5 health");
	else add_text_message("You got 10 health");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/****************\
|** MINIGUN AI **|
\****************/
void minigun_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.bullets_left < 999 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the minigun avalible as a weapon
	if (player.bullets_left < 0) player.bullets_left = 0;

	// This gives the player 50 bullets and checks to make sure that you have no more than the limit of 999 bullets
	player.bullets_left += 50;
	if (player.bullets_left > 999) player.bullets_left = 999;

	// This picks the mini gun if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 1;

	// Play the pickup weapon sound
	play_sample(worminator_data_file[PICKUP_WEAPON_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the minigun
	player.score += 25;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the Minigun");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/************************\
|** GETABLE BULLETS AI **|
\************************/
void getable_bullets_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.bullets_left < 999 && player.bullets_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 50 or 100 bullets and checks to make sure that you have no more than the limit of 999 bullets
	if (sprites[sprite_number].frame == ITEM_BULLETS_SMALL) player.bullets_left += 50;
	else player.bullets_left += 100;
	if (player.bullets_left > 999) player.bullets_left = 999;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the bullets
	player.score += 10;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_BULLETS_SMALL) add_text_message("You got 50 bullets");
	else add_text_message("You got 100 bullets");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/****************\
|** SHOTGUN AI **|
\****************/
void shotgun_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.shells_left < 50 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the shotgun avalible as a weapon
	if (player.shells_left < 0) player.shells_left = 0;

	// This gives the player 5 shells and checks to make sure that you have no more than the limit of 50 shells
	player.shells_left += 5;
	if (player.shells_left > 50) player.shells_left = 50;

	// This picks the shotgun if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 2;

	// Play the pickup weapon sound
	play_sample(worminator_data_file[PICKUP_WEAPON_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the shotgun
	player.score += 25;

	// This will refresh the stats to display the new shell total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the Shotgun");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/***********************\
|** GETABLE SHELLS AI **|
\***********************/
void getable_shells_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.shells_left < 50 && player.shells_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 5 or 25 shells and checks to make sure that you have no more than the limit of 50 shells
	if (sprites[sprite_number].frame == ITEM_SHELLS_SMALL) player.shells_left += 5;
	else player.shells_left += 25;
	if (player.shells_left > 50) player.shells_left = 50;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the shells
	player.score += 10;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_SHELLS_SMALL) add_text_message("You got 5 shells");
	else add_text_message("You got 25 shells");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/************************\
|** ROCKET LAUNCHER AI **|
\************************/
void rocket_launcher_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.rockets_left < 75 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the rocket launcher avalible as a weapon
	if (player.rockets_left < 0) player.rockets_left = 0;

	// This gives the player 5 rockets and checks to make sure that you have no more than the limit of 75 rockets
	player.rockets_left += 5;
	if (player.rockets_left > 75) player.rockets_left = 75;

	// This picks the rocket launcher if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 3;

	// Play the pickup weapon sound
	play_sample(worminator_data_file[PICKUP_WEAPON_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the rocket launcher
	player.score += 25;

	// This will refresh the stats to display the new rocket total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the Rocket Launcher");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/************************\
|** GETABLE ROCKETS AI **|
\************************/
void getable_rockets_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.rockets_left < 75 && player.rockets_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 1 or 5 rockets and checks to make sure that you have no more than the limit of 75 rockets
	if (sprites[sprite_number].frame == ITEM_ROCKETS_SMALL) player.rockets_left += 1;
	else player.rockets_left += 5;
	if (player.rockets_left > 75) player.rockets_left = 75;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the rockets
	player.score += 10;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_ROCKETS_SMALL) add_text_message("You got 1 rocket");
	else add_text_message("You got 5 rockets");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/******************\
|** LASER GUN AI **|
\******************/
void laser_gun_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.cells_left < 75 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the laser gun avalible as a weapon
	if (player.cells_left < 0) player.cells_left = 0;

	// This gives the player 10 cells and checks to make sure that you have no more than the limit of 75 cells
	player.cells_left += 25;
	if (player.cells_left > 75) player.cells_left = 75;

	// This picks the laser gun if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 5;

	// Play the pickup weapon sound
	play_sample(worminator_data_file[PICKUP_WEAPON_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the laser gun
	player.score += 25;

	// This will refresh the stats to display the new cell total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the Laser Gun");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/**********************\
|** GETABLE CELLS AI **|
\**********************/
void getable_cells_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.cells_left < 75 && player.cells_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 25 or 50 cells and checks to make sure that you have no more than the limit of 75 cells
	if (sprites[sprite_number].frame == ITEM_CELLS_SMALL) player.cells_left += 25;
	else player.cells_left += 50;
	if (player.cells_left > 75) player.cells_left = 75;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the cells
	player.score += 10;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_CELLS_SMALL) add_text_message("You got 25 cells");
	else add_text_message("You got 50 cells");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/*********************\
|** FLAMETHROWER AI **|
\*********************/
void flamethrower_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.gasoline_left < 75 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the flame thrower avalible as a weapon
	if (player.gasoline_left < 0) player.gasoline_left = 0;

	// This gives the player 10 gasoline and checks to make sure that you have no more than the limit of 25 gasoline
	player.gasoline_left += 10;
	if (player.gasoline_left > 25) player.gasoline_left = 25;

	// This picks the flamethrower if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 6;

	// Play the pickup weapon sound
	play_sample(worminator_data_file[PICKUP_WEAPON_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the flamethrower
	player.score += 25;

	// This will refresh the stats to display the new gasoline total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the Flamethrower");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/*************************\
|** GETABLE GASOLINE AI **|
\*************************/
void getable_gasoline_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.gasoline_left < 25 && player.gasoline_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 5 or 10 gasoline and checks to make sure that you have no more than the limit of 25 gasoline
	if (sprites[sprite_number].frame == ITEM_GASOLINE_SMALL) player.gasoline_left += 5;
	else player.gasoline_left += 10;
	if (player.gasoline_left > 25) player.gasoline_left = 25;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the gasoline
	player.score += 10;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_GASOLINE_SMALL) add_text_message("You got 5 gasoline");
	else add_text_message("You got 25 gasoline");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/**********************\
|** MORTAR CANNON AI **|
\**********************/
void mortar_cannon_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.mortars_left < 25 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the mortar cannon avalible as a weapon
	if (player.mortars_left < 0) player.mortars_left = 0;

	// This gives the player 5 mortars and checks to make sure that you have no more than the limit of 25 mortars
	player.mortars_left += 5;
	if (player.mortars_left > 25) player.mortars_left = 25;

	// This picks the mortar cannon if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 7;

	// Play the pickup weapon sound
	play_sample(worminator_data_file[PICKUP_WEAPON_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the mortar cannon
	player.score += 25;

	// This will refresh the stats to display the new plasma total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the Mortar Cannon");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/************************\
|** GETABLE MORTARS AI **|
\************************/
void getable_mortars_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.mortars_left < 25 && player.mortars_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 1 or 5 mortars and checks to make sure that you have no more than the limit of 25 mortars
	if (sprites[sprite_number].frame == ITEM_MORTARS_SMALL) player.mortars_left += 1;
	else player.mortars_left += 5;
	if (player.mortars_left > 25) player.mortars_left = 25;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the mortars
	player.score += 10;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_MORTARS_SMALL) add_text_message("You got 1 mortar");
	else add_text_message("You got 5 mortars");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/************\
|** BFG AI **|
\************/
void bfg_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.plasma_left < 10 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the bfg avalible as a weapon
	if (player.plasma_left < 0) player.plasma_left = 0;

	// This gives the player 2 plasma and checks to make sure that you have no more than the limit of 10 plasma
	player.plasma_left += 2;
	if (player.plasma_left > 10) player.plasma_left = 10;

	// This picks the bfg if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 8;

	// This plays the bfg pickup weapon sound
	play_sample(worminator_data_file[PICKUP_BFG_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the bfg
	player.score += 500;

	// This will refresh the stats to display the new plasma total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the BFG 1574");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/***********************\
|** GETABLE PLASMA AI **|
\***********************/
void getable_plasma_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.plasma_left < 10 && player.plasma_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 1 or 2 plasma and checks to make sure that you have no more than the limit of 10 plasma
	if (sprites[sprite_number].frame == ITEM_PLASMA_SMALL) player.plasma_left++;
	else player.plasma_left += 2;
	if (player.plasma_left > 10) player.plasma_left = 10;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the plasma
	player.score += 50;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_PLASMA_SMALL) add_text_message("You got 1 plasma");
	else add_text_message("You got 2 plasma");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/******************\
|** MINELAYER AI **|
\******************/
void minelayer_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.mines_left < 15 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This makes the minelayer avalible as a weapon
	if (player.mines_left < 0) player.mines_left = 0;

	// This gives the player 5 mines and checks to make sure that you have no more than the limit of 15 mines
	player.mines_left += 5;
	if (player.mines_left > 15) player.mines_left = 15;

	// Play the pickup weapon sound
	play_sample(worminator_data_file[PICKUP_WEAPON_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the minelayer
	player.score += 25;

	// This picks the minelayer if the player does not have a different gun selected
	if (player.current_weapon == 0) desired_weapon = 9;

	// This will refresh the stats to display the new plasma total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the MineLayer");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/**********************\
|** GETABLE MINES AI **|
\**********************/
void getable_mines_ai(int sprite_number)
{
unsigned char spawn_loop;

if (player.mines_left < 15 && player.mines_left >= 0 && sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the player 1 or 5 mines and checks to make sure that you have no more than the limit of 15 mines
	if (sprites[sprite_number].frame == ITEM_MINES_SMALL) player.mines_left++;
	else player.mines_left += 5;
	if (player.mines_left > 15) player.mines_left = 10;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the mines
	player.score += 10;

	// This will refresh the stats to display the new bullet total and highlight the weapon
	update_player_stats();

	// This displays a message to the player
	if (sprites[sprite_number].frame == ITEM_MINES_SMALL) add_text_message("You got 1 mine");
	else add_text_message("You got 2 mines");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/********************\
|** RED KEYCARD AI **|
\********************/
void red_keycard_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE && player.has_red_keycard == FALSE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the red keycard
	player.has_red_keycard = TRUE;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the red keycard
	player.score += 50;

	// This will refresh the stats to show the keycard
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the red keycard");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/**********************\
|** GREEN KEYCARD AI **|
\**********************/
void green_keycard_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE && player.has_green_keycard == FALSE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the green keycard
	player.has_green_keycard = TRUE;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the green keycard
	player.score += 50;

	// This will refresh the stats to show the keycard
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the green keycard");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/*********************\
|** BLUE KEYCARD AI **|
\*********************/
void blue_keycard_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE && player.has_blue_keycard == FALSE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// This gives the blue keycard
	player.has_blue_keycard = TRUE;

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the blue keycard
	player.score += 50;

	// This will refresh the stats to show the keycard
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got the blue keycard");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/***************\
|** LETTER AI **|
\***************/
void letter_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// Spawn a flyup sprite
	spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + 5, NULL, NULL, NULL);

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the letter
	player.score += 500;

	// This will refresh the stats to show the new point total
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got a wormy letter");

	// This considers the letter order and order bonus cases
	if (sprites[sprite_number].sprite_type == LETTER_W_SPRITE) {
		if (player.letter_order == NULL) player.letter_order = 1;
		else player.letter_order = -1;
		}
	else if (sprites[sprite_number].sprite_type == LETTER_O_SPRITE) {
		if (player.letter_order == 1) player.letter_order = 2;
		else player.letter_order = -1;
		}
	else if (sprites[sprite_number].sprite_type == LETTER_R_SPRITE) {
		if (player.letter_order == 2) player.letter_order = 3;
		else player.letter_order = -1;
		}
	else if (sprites[sprite_number].sprite_type == LETTER_M_SPRITE) {
		// Award the actual bonus
		if (player.letter_order == 3) {
			// Make some extra sparks so it looks fancy
			for (spawn_loop = 0; spawn_loop < 24; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 60.00) / 20.00, NULL);
			for (spawn_loop = 0; spawn_loop < 24; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 60.00) / 20.00, NULL);
			for (spawn_loop = 0; spawn_loop < 24; spawn_loop++) spawn_sprite(SMALL_BLUE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 60.00) / 20.00, NULL);

			// Spawn flyup sprites
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels - 16, sprites[sprite_number].y_position_in_pixels + 5 - 16, NULL, NULL, NULL);
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels - 16, sprites[sprite_number].y_position_in_pixels + 5, NULL, NULL, NULL);
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels - 16, sprites[sprite_number].y_position_in_pixels + 5 + 16, NULL, NULL, NULL);
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + 5 - 16, NULL, NULL, NULL);
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + 5 + 16, NULL, NULL, NULL);
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels + 16, sprites[sprite_number].y_position_in_pixels + 5 - 16, NULL, NULL, NULL);
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels + 16, sprites[sprite_number].y_position_in_pixels + 5, NULL, NULL, NULL);
			spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels + 16, sprites[sprite_number].y_position_in_pixels + 5 + 16, NULL, NULL, NULL);

			// This gives the player a ton of points for getting the word worm spelled properly
			player.score += 4000;

			// This will refresh the stats to show the new point total
			update_player_stats();

			// This displays a message to the player
			add_text_message("You got the superwormy spelling bonus");

			// Reset the leter_order counter just in case
			player.letter_order = NULL;
			}
		else player.letter_order = -1;
		}

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/*********************\
|** SODA SIXPACK AI **|
\*********************/
void soda_sixpack_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// Spawn a flyup sprite
	spawn_sprite(BONUS_FLYUP_50_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + 5, NULL, NULL, NULL);

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the soda
	player.score += 50;

	// This will refresh the stats to show the new point total
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got a soda sixpack");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/******************\
|** DOUGHNUTS AI **|
\******************/
void doughnuts_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// Spawn a flyup sprite
	spawn_sprite(BONUS_FLYUP_100_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + 5, NULL, NULL, NULL);

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the doughnuts
	player.score += 100;

	// This will refresh the stats to show the new point total
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got some doughnuts");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/*************************\
|** BOX OF DOUGHNUTS AI **|
\*************************/
void box_of_doughnuts_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// Spawn a flyup sprite
	spawn_sprite(BONUS_FLYUP_250_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + 5, NULL, NULL, NULL);

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the box of doughnuts
	player.score += 250;

	// This will refresh the stats to show the new point total
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got a box of doughnuts");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}

/*****************\
|** MUD BEER AI **|
\*****************/
void mud_beer_ai(int sprite_number)
{
unsigned char spawn_loop;

if (sprite_is_touching_player(sprite_number) == TRUE) {

	// Make some sparks so it looks fancy
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
	for (spawn_loop = 0; spawn_loop < 4; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, sprites[sprite_number].x_position_in_pixels + 10, sprites[sprite_number].y_position_in_pixels + 8, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);

	// Spawn a flyup sprite
	spawn_sprite(BONUS_FLYUP_500_POINT_SPRITE, sprites[sprite_number].x_position_in_pixels, sprites[sprite_number].y_position_in_pixels + 5, NULL, NULL, NULL);

	// Play the pickup item sound
	play_sample(worminator_data_file[PICKUP_ITEM_SOUND].dat, 255, 128, 1000, FALSE);

	// This gives the player some points for getting the mud beer
	player.score += 500;

	// This will refresh the stats to show the new point total
	update_player_stats();

	// This displays a message to the player
	add_text_message("You got a bottle of mud beer");

	// Kill this sprite
	destroy_sprite(sprite_number);
	}
}